﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="DisabiltyRatingScale.aspx.cs"
    Inherits="TBI_Instruments_DisabiltyRatingScale" Title="Untitled Page" %>
<%@ Import Namespace="AntiXssEnc=Microsoft.Security.Application" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        
        .detailTable
        {
        	border:0px;
        	background-color:#FFFFFF;
        }
        
        .detailTable td
        {
        	border:0px;
        	background-color:#FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Disability Rating Scale (DRS)"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSnum" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSnum" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="DRS" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" CausesValidation="false" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <div style="padding:5px; width: 900px;">
                        Disability Rating Scale ratings to be completed within 72 hours after Rehab. Admission.
                        <br />
                        And within 72 hours before Rehab. Discharge.<br />
                        <br />
                        The psychosocial adaptability or "employability" item takes into account overall cognitive and physical ability to be an
                        employee, homemaker or student.<br />
                        This determination should take into account considerations such as the following:<br />
                        <ol>
                            <li>Able to understand, remember and follow instructions.</li>
                            <li>Can plan and carry out tasks at least at the level of an office clerk or in simple routine, repetitive industrial situation
                                or can do school assignments.</li>
                            <li>Ability to remain oriented, relevant and appropriate in work and other psychosocial situations.</li>
                            <li>Ability to get to and from work or shopping centers using private or public transportation effectively.</li>
                            <li>Ability to deal with number concepts.</li>
                            <li>Ability to make purchases and handle simple money exchange problems</li>
                            <li>Ability to keep track of time and appointments</li>
                        </ol>
                    </div>
                </asp:Panel>
                <!-- End Instruction Area -->
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td style="vertical-align:top;">
                                <!--Date-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="6">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td style="vertical-align:top;">
                                <!--Date picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="7">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="8" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Date is required."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td style="vertical-align:top;">
                                <!--Type of Encounter-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForTypeOfEncounter" runat="server" AssociatedControlID="rblTOE" SkinID="DataLabel" TabIndex="9">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td style="vertical-align:top;">
                                <!-- Type of Encounter  Choice List-->
                                <asp:RadioButtonList ID="rblTOE" runat="server" RepeatDirection="Horizontal" DataSourceID="ObjectDataSourceTOE" TabIndex="10"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question TOE Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorTOE" runat="server" ControlToValidate="rblTOE" TabIndex="11" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Type of Encounter Selection is required."></asp:RequiredFieldValidator>
                                <!--Question TOE Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceTOE" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQTOE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question TOE : Question Number-->
                                <asp:HiddenField ID="HiddenQTOE" runat="server" Visible="false" Value="TYP" />
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table style="width: 1000px;">
                        <tr>
                            <td colspan="2">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="12" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQA" runat="server" AssociatedControlID="rblQA" SkinID="DataLabel" TabIndex="19">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 500px;">
                                <!-- Question A Choice List-->
                                <asp:RadioButtonList ID="rblQA" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQA" TabIndex="20"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question A Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQA" runat="server" ControlToValidate="rblQA" TabIndex="21" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question A Selection is required."></asp:RequiredFieldValidator>
                                <!--Question A Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQA" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQA" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question A : Question Number-->
                                <asp:HiddenField ID="HiddenQA" runat="server" Visible="false" Value="A" />
                            </td>
                            <td>
                                <!-- Question A: Details -->
                                <asp:GridView ID="gvQA" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQA" ShowHeader="false" 
                                CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind (B. COMMUNICATION ABILITY) -->
                                <asp:Label ID="LabelForQB" runat="server" AssociatedControlID="rblQB" SkinID="DataLabel" TabIndex="22">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td class="style2">
                                <!-- Question B Choice List-->
                                <asp:RadioButtonList ID="rblQB" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQB" TabIndex="23"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question B Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQB" runat="server" ControlToValidate="rblQB" TabIndex="24" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question B Selection is required."></asp:RequiredFieldValidator>
                                <!--Question B Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQB" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQB" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question B : Question Number-->
                                <asp:HiddenField ID="HiddenQB" runat="server" Visible="false" Value="B" />
                            </td>
                            <td class="style2">
                                <!-- Question B: Details -->
                                <asp:GridView ID="gvQB" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQB" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2" class="style1">
                                <!-- Get text in code-behind (C. MOTOR RESPONSE) -->
                                <asp:Label ID="LabelForQC" runat="server" AssociatedControlID="rblQC" SkinID="DataLabel" TabIndex="25">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question C Choice List-->
                                <asp:RadioButtonList ID="rblQC" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQC" TabIndex="26"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question C Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQC" runat="server" ControlToValidate="rblQC" TabIndex="27" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question C Selection is required."></asp:RequiredFieldValidator>
                                <!--Question C Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQC" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQC" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question C: Question Number-->
                                <asp:HiddenField ID="HiddenQC" runat="server" Visible="false" Value="C" />
                            </td>
                            <td>
                                <!-- Question C: Details -->
                                <asp:GridView ID="gvQC" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQC" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind (D.FEEDING (COGNITIVE ABILITY ONLY)) -->
                                <asp:Label ID="LabelForQD" runat="server" AssociatedControlID="rblQD" SkinID="DataLabel" TabIndex="28">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question D Choice List-->
                                <asp:RadioButtonList ID="rblQD" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQD" TabIndex="29"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question D Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQD" runat="server" ControlToValidate="rblQD" TabIndex="30" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question D Selection is required."></asp:RequiredFieldValidator>
                                <!--Question D Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQD" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQD" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question D: Question Number-->
                                <asp:HiddenField ID="HiddenQD" runat="server" Visible="false" Value="D" />
                            </td>
                            <td>
                                <!-- Question D: Details -->
                                <asp:GridView ID="gvQD" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQD" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind (E.TOILETING (COGNITIVE ABILITY ONLY))) -->
                                <asp:Label ID="LabelForQE" runat="server" AssociatedControlID="rblQE" SkinID="DataLabel" TabIndex="31">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question E Choice List-->
                                <asp:RadioButtonList ID="rblQE" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQE" TabIndex="32"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question E Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQE" runat="server" ControlToValidate="rblQE" TabIndex="33" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question E Selection is required."></asp:RequiredFieldValidator>
                                <!--Question E Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQE" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQE" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question E: Question Number-->
                                <asp:HiddenField ID="HiddenQE" runat="server" Visible="false" Value="E" />
                            </td>
                            <td>
                                <!-- Question E: Details -->
                                <asp:GridView ID="gvQE" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQE" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind (F.GROOMING (COGNITIVE ABILITY ONLY))) -->
                                <asp:Label ID="LabelForQF" runat="server" AssociatedControlID="rblQF" SkinID="DataLabel" TabIndex="34">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question F Choice List-->
                                <asp:RadioButtonList ID="rblQF" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQF" TabIndex="35"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question F Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQF" runat="server" ControlToValidate="rblQF" TabIndex="36" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question F Selection is required."></asp:RequiredFieldValidator>
                                <!--Question F Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQF" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQF" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question F: Question Number-->
                                <asp:HiddenField ID="HiddenQF" runat="server" Visible="false" Value="F" />
                            </td>
                            <td>
                                <!-- Question F: Details -->
                                <asp:GridView ID="gvQF" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQF" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind (G.LEVEL OF FUNCTIONING (PHYSICAL, MENTAL, EMOTIONAL OR SOCIAL FUNCTION) -->
                                <asp:Label ID="LabelForQG" runat="server" AssociatedControlID="rblQG" SkinID="DataLabel" TabIndex="37">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question G Choice List-->
                                <asp:RadioButtonList ID="rblQG" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQG" TabIndex="38"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question G Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQG" runat="server" ControlToValidate="rblQG" TabIndex="39" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question G Selection is required."></asp:RequiredFieldValidator>
                                <!--Question G Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQG" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQG" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question G: Question Number-->
                                <asp:HiddenField ID="HiddenQG" runat="server" Visible="false" Value="G" />
                            </td>
                            <td>
                                <!-- Question G: Details -->
                                <asp:GridView ID="gvQG" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQG" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <!-- Get text in code-behind (H."EMPLOYABILITY"(AS A FULL TIME WORKER, HOMEMAKER, OR STUDENT)) -->
                                <asp:Label ID="LabelForQH" runat="server" AssociatedControlID="rblQH" SkinID="DataLabel" TabIndex="40">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!-- Question H Choice List-->
                                <asp:RadioButtonList ID="rblQH" runat="server" RepeatDirection="Vertical" DataSourceID="ObjectDataSourceQH" TabIndex="41"
                                    DataTextField="CHOICE_NAME" DataValueField="STD_QUESTION_CHOICE_ID" CssClass="" ValidationGroup="OnSave" AutoPostBack="false">
                                </asp:RadioButtonList>
                                <!--Question H Required Validator-->
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQH" runat="server" ControlToValidate="rblQH" TabIndex="42" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Question H Selection is required."></asp:RequiredFieldValidator>
                                <!--Question H Object Data Source-->
                                <asp:ObjectDataSource ID="ObjectDataSourceQH" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType" TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQH" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <!--Question H: Question Number-->
                                <asp:HiddenField ID="HiddenQH" runat="server" Visible="false" Value="H" />
                            </td>
                            <td>
                                <!-- Question H: Details -->
                                <asp:GridView ID="gvQH" runat="server" Width="100%" AutoGenerateColumns="false" DataSourceID="ObjectDataSourceQH" ShowHeader="false" CssClass="detailTable" GridLines="None">
                                    <Columns>
                                        <asp:TemplateField>
                                            <ItemTemplate>
                                                <%#AntiXssEnc.Encoder.HtmlEncode(Convert.ToString(Eval("CHOICE_TEXT")))%>
                                            </ItemTemplate>
                                        </asp:TemplateField>
                                    </Columns>
                                </asp:GridView>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>
                
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="43" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="44" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="45" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
